/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.common.TimeTicks;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Label;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class TimeTicksRO
extends Label
implements JDMInput {
    private TimeTicks timeTicks;
    private static final int HSECONDS_IN_DAY = 8640000;
    private static final int HSECONDS_IN_HOUR = 360000;
    private static final int HSECONDS_IN_MINUTE = 6000;
    private static ResourceBundle myResources = null;
    protected String updays = new String(TimeTicksRO.getNLSString("updays"));
    protected boolean hasErrorValue;
    protected boolean ignoreValue;

    public TimeTicksRO() {
        this.setForeground(JmaColors.textText);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public Object getValue() {
        return this.timeTicks;
    }

    public void setValue(Object object) {
        this.hasErrorValue = false;
        this.ignoreValue = false;
        if (object instanceof TimeTicks || object instanceof Integer) {
            this.timeTicks = object instanceof Integer ? new TimeTicks(((Integer)object).longValue()) : (TimeTicks)object;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = this.timeTicks.value / 8640000L;
            long l5 = this.timeTicks.value % 8640000L;
            if (l5 > 0L) {
                l3 = l5 / 360000L;
                if ((l5 %= 360000L) > 0L) {
                    l2 = l5 / 6000L;
                    if ((l5 %= 6000L) > 0L) {
                        l = l5 / 100L;
                    }
                }
            }
            Object[] objectArray = new Object[]{new Long(l4), new Long(l3), new Long(l2), new Long(l)};
            String string = MessageFormat.format(this.updays, objectArray);
            this.setText(string);
            return;
        }
        if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            this.setText(specialValue.toString());
            this.hasErrorValue = true;
            if (object instanceof NotSupported) {
                this.ignoreValue = true;
                return;
            }
        } else {
            this.setText(object.toString());
        }
    }

    public void setValue(String string) {
        this.hasErrorValue = false;
        this.ignoreValue = false;
        TimeTicks timeTicks = new TimeTicks(0L);
        timeTicks.fromString(string);
        this.setValue(timeTicks);
    }

    protected static String getNLSString(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.TimeTicksROResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public boolean isValidValue() {
        return !this.hasErrorValue;
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }
}

